<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Extension of Codeigniter's {@link http://codeigniter.com/user_guide/helpers/html_helper.html html_helper}.
*
* @package direct-project-innovation-initiative
* @subpackage helpers
* @filesource
*/

load_libraries('Error_helper', 'Validator');

/**
* Takes an associative array of HTML attributes and returns the values as a string ready to be added to an HTML tag
*
* Example array: array('id' => 'display_name', 'class' => 'text-input numeric', 'required' => 'required').
*
* @param array
* @return string
*/
function attributes_to_string($attributes){
	if(is_string($attributes)) return $attributes;
	if(!validates_as('associative_array', $attributes)) return should_be('string or an associative array', $attributes);
	$markup = '';
	foreach ($attributes as $key => $value){
		if(is_array($value))
			$value = implode(' ', $value);
		
		$markup .= ' '.$key.'="'.$value.'"';
	}
	return $markup;
}

/**
* Generates a full link tag for an internal link.
* Similar to CI's {@link http://codeigniter.com/user_guide/helpers/url_helper.html site_url()} function, but generates a full link tag instead of just
* the path.
*
* For example:
* <code>
* $attributes = array('title'=>'Log Out', 'onclick' => "return confirm('Are you sure you want to log out?');");
* $markup = link_to('logout','Log Out',$attributes); 
* echo $markup; //<a href="http://src.bah.com/logout" title="Log Out" onclick="return confirm('Are you sure you want to log out?');">Log Out</a> 
* </code>
* 
* @uses link_to_url()
*
* @param string The path for the link. This can be either a full url or an internal path. If it's a path, it will be passed to CI's site_url() to generate the full url.
* @param string (Optional) The text or HTML that should be the content of this link.  This will default to the URL if not supplied.
* @param array (Optional) Any attributes that should be contained in the opening tag (e.g. class, title, onmouseover, etc.)
* @return string HTML link tag
*/
function link_to($path, $text='',$attributes=array()){
	if(!string_begins_with('http', $path))
		$url = site_url($path);
	else
		$url = $path;
	return link_to_url($url, $text, $attributes);
}


function link_to_url($url, $text='', $attributes=array()){
	if(!is_numeric($text) && empty($text))
		$text = $url;
	return '<a href="'.$url.'"'.attributes_to_string($attributes).'>'.$text.'</a>';
}

/**
* Link the text if $condition is true, otherwise return it in a span.
* This uses {@link link_to()} in order to generate a link.
* Highly useful for things like tabs and breadcrumbs.
* @uses link_to()
* @param boolean Whether or not the this should be displayed as a links.
* @param string The path for the link.  This will be passed to codeigniter's site_url() to generate the full url.
* @param string (Optional) The text or HTML that should be the content of this link.
* @param array (Optional) Any attributes that should be contained in the opening tag (e.g. class, title, onmouseover, etc.) 
* @return string HTML link tag if $condition was true, span containing $text otherwise
* @todo Use tag() to generate the span so that we can pass the same attributes so that classes, ids, etc. could be the same.
*/
function link_to_if($condition, $path, $text, $attributes=array()){
	if($condition)
		return link_to($path, $text, $attributes);
	else
		return tag('span', $text, $attributes);
}

function link_to_unless($condition, $path, $text, $attributes=array()){
	return link_to_if(!$condition, $path, $text, $attributes);
}

/**
* Replaces spaces and underscores in a string with dashes to fit CSS standards
* @param string
* @return string
*/
function make_string_css_friendly($string){
	if(!validates_as('nonempty_string', $string)) return should_be('nonempty string', $string);
	return strip_from_beginning('-', strip_from_end('-', preg_replace('/-{2,}/', '-', preg_replace('/[^\p{L}\p{M}\p{N}]/u', '-',  mb_strtolower($string)))));
}


/**
* Merges two associative arrays of HTML attributes.
*
* Like {@link array_merge()}, but correctly merges classes. 
* Example array: array('id' => 'display_name', 'class' => 'text-input numeric', 'required' => 'required').
*
* @param array
* @param array
* @return array
*/
function merge_attributes($one, $two){
	if(!validates_as('associative_array', $one)) return should_be('associative_array', $one);
	if(!validates_as('associative_array', $two)) return should_be('associative_array', $two);
	
	if(!empty($one['class']) && !empty($two['class'])){
		$classes_for_one = explode(' ', $one['class']);
		$classes_for_two = explode(' ', $two['class']);
		$two['class'] = implode(' ', array_merge($classes_for_one, $classes_for_two));
	}

	return array_merge($one, $two);
}